<?php
/**
 * This is the template that displays the edit comment form. It gets POSTed to comments ctrl.
 *
 * Note: don't code this URL by hand, use the template functions to generate it!
 *
 * This file is part of the b2evolution/evocms project - {@link http://b2evolution.net/}.
 * See also {@link http://sourceforge.net/projects/evocms/}.
 *
 * @copyright (c)2003-2014 by Francois Planque - {@link http://fplanque.com/}.
 *
 * @license http://b2evolution.net/about/license.html GNU General Public License (GPL)
 *
 * @package evoskins
 *
 * @version $Id: _edit_comment.disp.php 6136 2014-03-08 07:59:48Z manuel $
 */
if( !defined('EVO_MAIN_INIT') ) die( 'Please, do not access this page directly.' );

global $Blog, $edited_Comment, $comment_Item, $comment_content;
global $display_params, $admin_url, $samedomain_htsrv_url, $dummy_fields;

$form_action = url_add_param( $admin_url, 'ctrl=comments' );

// Default params:
$disp_params = array_merge( array(
		'disp_edit_categories' => true,
		'edit_form_params' => array(
			'formstart'      => '<table class="bForums" width="100%" cellspacing="1" cellpadding="2" border="0"><tr><th colspan="2">'.T_('Editing reply').'</th></tr>',
			'formend'        => '</table>',
			'fieldset_begin' => '<tr class="top"><td colspan="2">',
			'fieldset_end'   => '</td></tr>',
			'fieldstart'     => '<tr>',
			'fieldend'       => '</tr>',
			'labelstart'     => '<td class="left"><strong>',
			'labelend'       => '</strong></td>',
			'inputstart'     => '<td class="row2 left">',
			'inputend'       => '</td>',
			'infostart'      => '<td class="row2 left">',
			'infoend'        => '</td>',
			'buttonsstart'   => '<tr><td colspan="2">',
			'buttonsend'     => '</td></tr>',
			'output'         => true
		),
		'categories_name'      => T_('Appears in'),
		'category_name'        => T_('Forum'),
		'category_main_title'  => T_('Main forum'),
		'category_extra_title' => T_('Additional forum'),
		'textarea_lines'       => 16,
		'form_comment_text'    => T_('Comment content'),
	), $display_params );

// BREADCRUMBS
echo '<div class="post_panel">';
$comment_Item = & $edited_Comment->get_Item();
$main_Chapter = & $comment_Item->get_main_Chapter();
$Skin->display_breadcrumbs( $main_Chapter->ID );
echo '</div><div class="clear"></div>';

$Form = new Form( $form_action, 'comment_edit', 'post' );

$Form->switch_template_parts( $disp_params['edit_form_params'] );

$Form->begin_form( 'inskin', '', $display_params );

	$Form->add_crumb( 'comment' );
	$Form->hidden( 'blog', $Blog->ID );
	$Form->hidden( 'mname', 'collections' );
	$Form->hidden( 'action_type', 'comment' );
	$Form->hidden( 'comment_ID', $edited_Comment->ID );
	$Form->hidden( 'redirect_to', url_add_tail( $comment_Item->get_permanent_url(), '#c'.$edited_Comment->ID ) );

	$Form->info( T_('In response to'), $comment_Item->get_title() );
	if( $edited_Comment->get_author_User() )
	{
		$Form->info( T_('Author'), $edited_Comment->get_author() );
	}
	else
	{
		$Form->text_input( 'newcomment_author', $edited_Comment->author, 20, T_('Author'), '', array('maxlength'=>100, 'style'=>'width: 99%;' ) );
		$Form->text_input( 'newcomment_author_email', $edited_Comment->author_email, 20, T_('Email'), '', array('maxlength'=>100, 'style'=>'width: 99%;') );
		$Form->text_input( 'newcomment_author_url', $edited_Comment->author_url, 20, T_('Website URL'), '', array('maxlength'=>100, 'style'=>'width: 99%;') );
	}

	ob_start();
	echo '<div class="comment_toolbars">';
	// CALL PLUGINS NOW:
	$Plugins->trigger_event( 'AdminDisplayToolbar', array(
			'target_type' => 'Comment',
			'edit_layout' => NULL,
			'Comment' => $edited_Comment,
		) );
	echo '</div>';
	$plugins_toolbar = ob_get_clean();

	$Form->switch_template_parts( array(
			'inputstart' => '<td class="row2 left">'.$plugins_toolbar,
		) );
	$Form->textarea_input( 'content', $comment_content, $disp_params['textarea_lines'], $disp_params['form_comment_text'], array( 'cols' => 60 , 'style' => 'width:99%', 'id' => $dummy_fields[ 'content' ] ) );

	// set b2evoCanvas for plugins
	echo '<script type="text/javascript">var b2evoCanvas = document.getElementById( "'.$dummy_fields[ 'content' ].'" );</script>';

	if( $current_User->check_perm( 'blog_edit_ts', 'edit', false, $Blog->ID ) )
	{ // ------------------------------------ TIME STAMP -------------------------------------
		$Form->switch_template_parts( array(
			'fieldstart' => '',
			'fieldend'   => '',
			'labelstart' => '',
			'labelend'   => '',
			'labelempty' => '',
			'inputstart' => '',
			'inputend'   => '',
			'output'     => false
		) );

		$comment_date_input = $Form->date_input( 'comment_issue_date', $edited_Comment->date, '' );
		$comment_date_input .= $Form->time_input( 'comment_issue_time', $edited_Comment->date, '' );

		$Form->switch_template_parts( $disp_params['edit_form_params'] );

		$Form->info( T_('Comment date'), $comment_date_input, '' );
	}

	if( $comment_Item->can_rate() || !empty( $edited_Comment->rating ) )
	{ // Rating is editable
		$edit_form_params = $disp_params['edit_form_params'];
		$before_rating = $edit_form_params['fieldstart'].$edit_form_params['labelstart'].T_('Rating').$edit_form_params['labelend'].$edit_form_params['inputstart'];
		$after_rating = $edit_form_params['inputend'].$edit_form_params['fieldend'];
		$edited_Comment->rating_input( array( 'before' => $before_rating, 'after' => $after_rating ) );
	}

	// Get those statuses which are not allowed for the current User to create comments in this blog
	$exclude_statuses = array_merge( get_restricted_statuses( $Blog->ID, 'blog_comment!', 'edit' ), array( 'redirected', 'trash' ) );
	// Get allowed visibility statuses
	$sharing_options = get_visibility_statuses( 'radio-options', $exclude_statuses );
	if( count( $sharing_options ) == 1 )
	{ // Only one visibility status is available, don't show radio but set hidden field
		$Form->hidden( 'comment_status', $sharing_options[0][0] );
	}
	else
	{ // Display visibiliy options
		$Form->radio( 'comment_status', $edited_Comment->status, $sharing_options, T_('Visibility'), true );
	}

	// Display renderers
	$comment_renderer_checkboxes = $edited_Comment->renderer_checkboxes( NULL, false );
	if( !empty( $comment_renderer_checkboxes ) )
	{
		$Form->info( T_('Text Renderers'), $comment_renderer_checkboxes );
	}

	// Display comment attachments
	$LinkOwner = new LinkComment( $edited_Comment );
	if( $LinkOwner->count_links() )
	{ // there are attachments to display
		$Form->switch_template_parts( array(
			'fieldset_begin' => '<tr><td class="left" valign="top"><strong>$fieldset_title$:</strong></td><td class="row2 left">',
		) );
		$Form->begin_fieldset( T_('Attachments') );
		if( $current_User->check_perm( 'files', 'view' ) )
		{ // User has permission to view files
			display_attachments( $LinkOwner );
		}
		else
		{
			echo T_('You do not have permission to edit file attachments for this comment');
		}
		$Form->end_fieldset();
		$Form->switch_template_parts( $disp_params['edit_form_params'] );
	}

	$Form->begin_fieldset();
	$Form->submit( array( 'actionArray[update]', T_('Save changes'), 'SaveButton submit' ) );
	$Form->end_fieldset();
$Form->end_form();

?>
<script type="text/javascript">
	function switch_edit_view()
	{
		var form = document.getElementById('comment_edit');
		if( form )
		{
			jQuery(form).append( '<input type="hidden" name="action" value="switch_view" />');
			form.submit();
		}
		return false;
	}
</script>